<?php
include 'database.php';
$transref = $_GET['ref'];
$sql = 'SELECT * FROM transactions WHERE transref = :transref';
$stmt = $pdo->prepare($sql);
$stmt->execute(['transref' => $transref]);

$data = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$data) {
    echo 'Transaction not found.';
    exit();
}

?>
<?php
$status = $data['status'];

switch ($status) {
    case 0:
        $statusText = 'Success';
        $statusClass = 'text-success'; // Bootstrap class for green text
        break;
    case 1:
        $statusText = 'Fail';
        $statusClass = 'text-danger'; // Bootstrap class for red text
        break;
    case 2:
        $statusText = 'Processing';
        $statusClass = 'text-warning'; // Bootstrap class for amber/yellow text
        break;
    default:
        $statusText = 'Unknown';
        $statusClass = 'text-muted'; // Bootstrap class for muted/grey text
        break;
}
?>

           
<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
<link rel="icon" type="image/png" href="../../assets/img/favicon.png" />
<script src="
https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.all.min.js
"></script>
<link href="
https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.min.css
" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.5.0-beta4/html2canvas.min.js"></script>
<link rel="icon" type="image/png" href="assets/img/favicon.png" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<title><?php echo $title; ?></title>
<link rel="stylesheet" type="text/css" href="https://app.dannvtu.com.ng/mobile/assets/styles/bootstrap.css" media="all">
<link rel="stylesheet" type="text/css" href="https://app.dannvtu.com.ng/mobile/assets/styles/style.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://app.dannvtu.com.ng/mobile/assets/fonts/css/fontawesome-all.min.css">    
<!--link rel="manifest" href="../assets/scripts/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js"-->
<link rel="apple-touch-icon" sizes="180x180" href="assets/app/icons/icon-192x192.png">
<link href="https://vjs.zencdn.net/7.17.0/video-js.css" rel="stylesheet" />
<!-- Fantasy -->
<link href="https://unpkg.com/@videojs/themes@1/dist/sea/index.css" rel="stylesheet">
<style>


.gradient-highlight{
        border-radius: 5rem !important;
        background-image: linear-gradient(to bottom, <?php echo $sitecolor; ?>, <?php echo $sitecolor; ?>) !important;
}
    .color-highlight{color: <?php echo $sitecolor; ?> !important; }
@media print {
    .pagebreak {
        clear: both;
        page-break-after: always;
    }
}

.radio-view{
  margin: auto;
  padding: 0;
  position:relative;
  max-width:520px;

}


.iphone {
  background: #ffffff;
  border-radius: 1em;
  box-sizing: border-box;
  padding: 2em;
  display: flex;
  flex-direction: column;
}
.iphone .title {
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  font-size: 0.75em;
  margin-bottom: 2em;
}
.iphone .album-cover {
  box-sizing: border-box;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
}

.iphone .album-cover img {
  width: 160px;
  height: 156px;
  border-radius: 50%;
}
.iphone .album-cover .song-title {
  
  margin-top:10px;
  text-align: center;
  padding-bottom: 0;
  margin-bottom: 0;
  color: #65717e;
}
.iphone .album-cover .artist-title {
  text-align: center;
  margin-top: 1em;
  padding: 3px 20px 3px 20px;
  font-size: 1em;
  color: #ffffff;
  background-color: #3333ff;
  border-radius: 5px;
}
.iphone .track {
  margin-top: 1em;
  height: 10px;
}
.iphone .track div {
  width: 5%;
  height: 100%;
  background: #3333ff;
  opacity: 0.75;
  border-radius: 15px;
}
.iphone .buttons {
  display: flex;
  justify-content: center;
  align-items: center;
  padding: 1em 0;
}
.iphone .lyrics {
  color: #7e8a98;
  margin-top: 2em;
  text-align: center;
  font-size: 0.75em;
  display: flex;
  flex-direction: column;
}

.neu {
  box-shadow: -5px -5px 15px 0px #ffffff9e, 5px 5px 15px 0px #a3b1c6a8;
  background: #e0e5ec;
  border-radius: 2em;
  border: 0;
}

.btn-r {
  padding: 15px 20px 15px 20px;
  border-radius: 30px;
  color: #7e8a98;
  outline: none;
  cursor: pointer;
  margin:0 25px 0px 25px;
}
.btn-r.lg {
  font-size: 1em;
}
.btn-r:hover {
  cursor: pointer;
  background: #eff2f5;
}

.red {
  color: #e22d49;
}
.spin {
  -webkit-animation-name: spin;
  -webkit-animation-duration: 20000ms;
  -webkit-animation-iteration-count: infinite;
  -webkit-animation-timing-function: linear;
  -moz-animation-name: spin;
  -moz-animation-duration: 20000ms;
  -moz-animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-name: spin;
  -ms-animation-duration: 20000ms;
  -ms-animation-iteration-count: infinite;
  -ms-animation-timing-function: linear;
  -o-transition: rotate(3600deg);
}
@-moz-keyframes spin {
    from { -moz-transform: rotate(0deg); }
    to { -moz-transform: rotate(360deg); }
}
@-webkit-keyframes spin {
    from { -webkit-transform: rotate(0deg); }
    to { -webkit-transform: rotate(360deg); }
}
@keyframes spin {
    from {transform:rotate(0deg);}
    to {transform:rotate(360deg);}
}

</style>
</head>
    
<body class="theme-light">

    
<div id="page">
  <div class="page-content header-clear-medium">
        
        <div class="card card-style">
            <div class="content">
                <div class="text-center"><img src="assets/images/waicon.png" style="width:50px; height:50px;" /></div>
                <p class="mb-0 font-600 text-dark text-center">Transaction Details</p>
               <h3 class="text-center <?php echo $statusClass; ?>"><?php echo $statusText; ?></h3>
                <hr/>
                <table class="table">
                   
                    <tr>
                        <td><b>Date:</b></td>
                        <td align="right"><?php echo $data['date']; ?></td>
                    </tr>
                    <tr>
                        <td><b>Service:</b></td>
                        <td align="right"><?php echo $data['servicename']; ?></td>
                    </tr>
                    <tr>
                        <td><b>Description:</b></td>
                        <td align="right"><?php echo $data['servicedesc']; ?></td>
                    </tr>
                    
                      <?php if($data->servicename == "Data"): ?>
                <tr>
                        <td><b>API Response:</b></td>
                <td align="right"><?php echo $data->api_response_log; ?></td>
                     </tr>
            <?php endif; ?>
            
           
<?php if(!isset($_GET["receipt"])): ?>

                    <tr>
                        <td><b>Amount:</b></td>
                        <td align="right">N<?php echo $data['amount']; ?></td>
                    </tr>
                    <tr>
                        <td><b>Old Balance:</b></td>
                        <td align="right">N<?php echo $data['oldbal']; ?></td>
                    </tr>
                     <tr>
                        <td><b>New Balance:</b></td>
                        <td align="right">N<?php echo $data['newbal']; ?></td>
                    </tr>
                     </form>    
                    <?php endif; ?>
                    
                    
                    

                </table> 
               <div class="text-center">
                    <?php if(!isset($_GET["receipt"])): ?>
                  
                    <?php endif; ?>
                    <?php if($data->servicename == "Data Pin" && $data->status == 0): ?>
                    <a href="view-pins?ref=<?php echo $_GET["ref"]; ?>" class="btn btn-primary btn-sm col-4" style="border-radius:2rem; margin-left:15px;">
                        <b>View Pins</b>
                    </a>
                    <?php endif; ?>
                    <?php if ($data->servicename == "Recharge Pin" && $data->status == 0): ?>
            <a href="view-recharge-pins?ref=<?php echo $_GET["ref"]; ?>" class="btn btn-primary btn-sm col-4" style="border-radius:2rem; margin-left:15px;">
                <b>View Pins</b>
            </a>
            <?php endif; ?>
            
            
  

               </div>
            </div>

        </div>

</div>

  
</div>
<script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
<script type="text/javascript" src="assets/scripts/bootstrap.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
<script type="text/javascript" src="assets/scripts/custom.js?v=1.8"></script>

</body>
</html>