<?php

class SubscriberModel extends Model
{
     //Get Api Config Values
        public function getConfigValue($list,$name){
			foreach($list AS $item){
				if($item->name == $name){return $item->value;}
			}
		}
    // Get API Settings
public function getApiConfiguration()
{
    try {
        $sql = "SELECT * FROM apiconfigs";
        $query = $this->dbh->prepare($sql);
        $query->execute();
        return $query->fetchAll(PDO::FETCH_OBJ);
    } catch (Exception $e) {
        return ["status" => "fail", "message" => $e->getMessage()];
    }
}

// Get Site Settings
public function getSiteConfiguration()
{
    try {
        $sql = "SELECT * FROM sitesettings WHERE sId = 1";
        $query = $this->dbh->prepare($sql);
        $query->execute();
        return $query->fetch(PDO::FETCH_OBJ);
    } catch (Exception $e) {
        return ["status" => "fail", "message" => $e->getMessage()];
    }
}

  public function retrieveUser($id)
    {
        $id = $this->normalizePhoneNumber($id);
        $id = (float) $id;
        $dbh = self::connect();
        $sql = "SELECT * FROM subscribers WHERE sPhone = $id";
        $queryC = $dbh->prepare($sql);
        $queryC->execute();
        $result = $queryC->fetch(PDO::FETCH_OBJ);
        
         $response = [
            "status" => "success",
            "Id" => $result->sId,
            "name" => $result->sFname . " " . $result->sLname,
            "phone" => $result->sPhone,
            "email" => $result->sEmail,
            "fname" => $result->sFname,
            "lname" => $result->sLname,
            "pin" => $result->sPin,
            "date" => $result->sRegDate,
            "image" => $result->sImage,
            "address" => $result->sAddress,
            "account_number" => $result->sPaymentPointBank,
            "account_name" => $result->sFname,
            "age" => $result->sAge,
            "sex" => $result->sSex,
            "user_type" => $result->sType,
            "refwallet" => $result->sRefWallet,
             "wallet" => $result->sWallet,
            "vercode" => $result->sVerCode,
            "moniepoint" => $result->sRolexBank,
            "payvessel" => $result->sPayVessel,
            "wema" => $result->sBankNo,
            "charges" => "1.7%",
            "username" => $result->SUsername,
            "isbank_verify" => $result->sVerified,
            "apikey" => $result->sApiKey,
            "notif" => "You are welcome, we are your one-stop platform for all
                        bills payment, airtime, data plans, and cable TV subscription.
                        All our services are available to you at a discount rate.
                        Our customer support team is available to you 24/7.",
            "vtuaccount" => "WAPAY-" . strtoupper(substr($result->sFname, 0, 3)),
            "pin_set" => isset($result->sPin) && $result->sPin >= 3 ? "yes" : "no"
        ];

        return (object) $response;
    
    }
    
    
       public function insertUserId($chat_id)
    {
        try {
            $sql = "INSERT INTO bot_subscribers (sPhone) VALUES (:sPhone)";
            $stmt = $this->dbh->prepare($sql);

            $stmt->bindParam(':sPhone', $chat_id);
            $stmt->execute();

            return ["status" => "success"];
        } catch (Exception $e) {
            return ["status" => "fail", "message" => $e->getMessage()];
        }
    }
     function sendMail($email, $subject, $message) {
    $url = "https://wapay.com.ng/mobile/home/route.php?sendMail";
    
    $postData = "email=$email&subject=$subject&message=$message";
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded'
    ]);
    
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        return "cURL Error: " . $error_msg;
    }
    
    curl_close($ch);
    return $response;
}

       
    

    public function updateUserId($chat_id, $balance)
    {
        try {
            $sql = "UPDATE bot_subscribers SET sBalance = :sBalance WHERE sPhone = :sPhone";
            $stmt = $this->dbh->prepare($sql);

            $stmt->bindParam(':sBalance', $balance, PDO::PARAM_STR);
            $stmt->bindParam(':sPhone', $chat_id, PDO::PARAM_STR);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                return ["status" => "success"];
            } else {
                return ["status" => "fail", "message" => "No rows affected"];
            }
        } catch (Exception $e) {
            return ["status" => "fail", "message" => $e->getMessage()];
        }
    }
    
   public function verifyUserExists($chat_id)
{
    try {
        // Normalize the phone number by replacing 234 with 0
        $normalizedPhone = $this->normalizePhoneNumber($chat_id);

        $sql = "SELECT sPhone FROM subscribers WHERE REPLACE(sPhone, ' ', '') LIKE ? OR REPLACE(sPhone, ' ', '') LIKE ?";
        $stmt = $this->dbh->prepare($sql);

        if (!$stmt) {
            return json_encode(["status" => "error", "message" => "Database error: Failed to prepare statement"]);
        }

        $pattern1 = "%$normalizedPhone"; // Match numbers ending with the normalized phone
        $pattern2 = "%" . substr($normalizedPhone, -10); // Match last 10 digits only

        // Use bindValue or execute with an array
        $stmt->execute([$pattern1, $pattern2]);

        $response = $stmt->rowCount() > 0 
            ? ["status" => "registered", "message" => "User exists"] 
            : ["status" => "not_registered", "message" => "User not found"];

        return json_encode($response);
    } catch (Exception $e) {
        return json_encode(["status" => "error", "message" => $e->getMessage()]);
    }
}

private function normalizePhoneNumber($phone)
{
    $phone = preg_replace('/\D/', '', $phone); // Remove non-numeric characters

    if (strpos($phone, "234") === 0) {
        return "0" . substr($phone, 3); // Replace leading 234 with 0
    } elseif (strpos($phone, "0") === 0 && strlen($phone) == 11) {
        return $phone; // Already in local format
    } else {
        return $phone; // Return as is if already formatted
    }
}

//Login User Account
public function loginUser($phone, $key) {
    $phone = $this->normalizePhoneNumber($phone);
    
    // Verify Registration Details
    $dbh = $this->connect();
    $hash = substr(sha1(md5($key)), 3, 10);
    
  $c = "SELECT * FROM subscribers WHERE sPhone = :ph AND sPass = :p";

	    	$queryC = $dbh->prepare($c);
	    	$queryC->bindParam(':ph',$phone,PDO::PARAM_STR);
	     	$queryC->bindParam(':p',$hash,PDO::PARAM_STR);
	     	$queryC->execute();
	      	$result=$queryC->fetch(PDO::FETCH_OBJ);
	      	
    if ($queryC->rowCount() > 0) {
        if ($result->sRegStatus == 1) {
            return (object) ["status" => "fail", "msg" => "Account Blocked, Please Contact Customer Support For Additional Information"];
        }

        // Store session data
        $_SESSION["loginId"] = $result->sId;
        $_SESSION["loginName"] = $result->sFname . " " . $result->sLname;
        $_SESSION["loginEmail"] = $result->sEmail;
        $_SESSION["loginPhone"] = $result->sPhone;

        // Set cookies
        setcookie("loginId", base64_encode($result->sId), time() + (2592000 * 30), "/");
        setcookie("loginState", base64_encode($result->sState), time() + (2592000 * 30), "/");
        setcookie("loginAccount", base64_encode($result->sType), time() + (2592000 * 30), "/");
        setcookie("loginPhone", base64_encode($result->sPhone), time() + (31540000 * 30), "/");
        setcookie("loginName", base64_encode($result->sFname), time() + (31540000 * 30), "/");

        // Generate User Login Token
        $randomToken = substr(str_shuffle("ABCDEFGHIJklmnopqrstvwxyz"), 0, 10);
        $userLoginToken = time() . $randomToken . mt_rand(100, 1000);
        $_SESSION["loginAccToken"] = $userLoginToken;

        // Save New User Login Token
        $sqlAc = "INSERT INTO userlogin (user, token) VALUES (:user, :token)";
        $queryAc = $dbh->prepare($sqlAc);
        $queryAc->bindParam(':user', $result->sId, PDO::PARAM_STR);
        $queryAc->bindParam(':token', $userLoginToken, PDO::PARAM_STR);
        $queryAc->execute();


if($result->sPaymentPointBank == "" || $result->sPaymentPointBank == null){
    
    $this->generatePaymentPointAccount($result->sId, $result->sFname, $result->sLname, $result->sPhone, $result->sEmail);
}
       
        $response = [
            "status" => "success",
            "Id" => $result->sId,
            "name" => $result->sFname . " " . $result->sLname,
            "phone" => $result->sPhone,
            "email" => $result->sEmail,
            "fname" => $result->sFname,
            "lname" => $result->sLname,
            "pin" => $result->sPin,
            "date" => $result->sRegDate,
            "image" => $result->sImage,
            "address" => $result->sAddress,
            "account_number" => $result->sPaymentPointBank,
            "account_name" => $result->sFname,
            "age" => $result->sAge,
            "sex" => $result->sSex,
            "user_type" => $result->sType,
            "refwallet" => $result->sRefWallet,
             "wallet" => $result->sWallet,
            "vercode" => $result->sVerCode,
            "moniepoint" => $result->sRolexBank,
            "payvessel" => $result->sPayVessel,
            "wema" => $result->sBankNo,
            "charges" => "1.7%",
            "username" => $result->SUsername,
            "isbank_verify" => $result->sVerified,
            "apikey" => $result->sApiKey,
            "notif" => "You are welcome, we are your one-stop platform for all
                        bills payment, airtime, data plans, and cable TV subscription.
                        All our services are available to you at a discount rate.
                        Our customer support team is available to you 24/7.",
            "vtuaccount" => "WAPAY-" . strtoupper(substr($result->sFname, 0, 3)),
            "pin_set" => isset($result->sPin) && $result->sPin >= 3 ? "yes" : "no"
        ];

        return (object) $response;
    } else {
        return (object) ["status" => "fail", "msg" => "Invalid Username Or Password"];
    }
}

public function generatePaymentPointAccount($id, $fname, $lname, $phone, $email)
   {
      $logContent = "ID: $id\n";
      $logContent .= "First Name: $fname\n";
      $logContent .= "Last Name: $lname\n";
      $logContent .= "Phone: $phone\n";
      $logContent .= "Email: $email\n";

      file_put_contents("paymentpoint_log.txt", $logContent, FILE_APPEND);

      $url = 'https://api.paymentpoint.co/api/v1/createVirtualAccount';
      $dbh = $this->connect();

      $d = $this->getApiConfiguration();
      $paymentPointStatus = $this->getConfigValue($d, "paymentPointStatus");
      $paymentPointApiKey = $this->getConfigValue($d, "paymentPointApiKey");
      $paymentPointApiSecret = $this->getConfigValue($d, "paymentPointApiSecret");
      $paymentPointBusinessId = $this->getConfigValue($d, "paymentPointBusinessId");

      $fname = str_replace(" ", "", trim($fname));
      $lname = str_replace(" ", "", trim($lname));
      $phone = trim($phone);
      $email = str_replace(" ", "", $email);

      $postData = [
         "email" => $email,
         "name" => $fname . ' ' . $lname,
         "phoneNumber" => $phone,
         "bankCode" => ['20946'],
         "businessId" => $paymentPointBusinessId,
      ];

      $ch = curl_init();
      curl_setopt_array($ch, [
         CURLOPT_URL => $url,
         CURLOPT_RETURNTRANSFER => true,
         CURLOPT_ENCODING => "",
         CURLOPT_MAXREDIRS => 10,
         CURLOPT_TIMEOUT => 0,
         CURLOPT_FOLLOWLOCATION => true,
         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
         CURLOPT_CUSTOMREQUEST => "POST",
         CURLOPT_POSTFIELDS => json_encode($postData),
         CURLOPT_HTTPHEADER => ["Authorization: Bearer $paymentPointApiSecret", "api-key: $paymentPointApiKey", "Content-Type: application/json"],
      ]);

      $result = curl_exec($ch);
      curl_close($ch);
      $value = json_decode($result, true);

      file_put_contents("paymentpoint_log.txt", "API Response: " . json_encode($value) . "\n", FILE_APPEND);

      if (isset($value['bankAccounts'][0]['accountNumber'])) {
         $accountNumber = $value['bankAccounts'][0]['accountNumber'];

         file_put_contents("paymentpoint_log.txt", "Account Number: $accountNumber\n", FILE_APPEND);

         $c = "UPDATE subscribers SET sPaymentPointBank = :ppb, sAccountLimit = '10000' WHERE sId = :id";
         $queryC = $dbh->prepare($c);
         $queryC->bindParam(':ppb', $accountNumber, PDO::PARAM_STR);
         $queryC->bindParam(':id', $id, PDO::PARAM_INT);
         $queryC->execute();

         file_put_contents("paymentpoint_log.txt", "Database updated successfully for ID: $id\n", FILE_APPEND);
      } else {
         file_put_contents("paymentpoint_log.txt", "Error: Account number not found in response.\n", FILE_APPEND);
      }
   }
	public function registerUser($fname,$lname,$email,$phone,$password,$transpin,$referal){
	    
			$state ="Ogun State";
			$account = "1";
		    $phone = $this->normalizePhoneNumber($phone);
			if($referal == "admin"){$saveCookies=FALSE; $referal="";}else{$saveCookies=TRUE;}

			//Verify Registration Details
			$dbh=$this->connect();
	    	$c="SELECT * FROM subscribers WHERE ";
			$c.= ($email<>"") ? " sEmail=:e OR sPhone=:p" : " sPhone=:p";
	    	$queryC = $dbh->prepare($c);
	    	if($email<>""){$queryC->bindParam(':e',$email,PDO::PARAM_STR);}
	     	$queryC->bindParam(':p',$phone,PDO::PARAM_STR);
	     	$queryC->execute();
	      	$result=$queryC->fetch(PDO::FETCH_ASSOC);
	      	$data=4;

	      	//Output Error Message If Data Already Exist
	      	if($queryC->rowCount() > 0){
	          
	          if($result["sPhone"] == $phone){$data = ["status" => "error", "msg" => "Phone Number Already Exist"]; }
	          if($email<>""){if($result["sEmail"] == $email){ $data = ["status" => "error", "msg" => "Email Already Exist"]; }}
	          if($result["sEmail"] == $email && $result["sPhone"] == $phone){$data =  ["status" => "error", "msg" => "Phone Number And Email Already Exist"]; }
	          
	          return (object) $data; 
	      	}
	      
	      	//Insert And Register Member
	      	else{
			   
				$hash=substr(sha1(md5($password)), 3, 10);
				$apiKey = substr(str_shuffle("0123456789ABCDEFGHIJklmnopqrstvwxyzAbAcAdAeAfAgAhBaBbBcBdC1C23C3C4C5C6C7C8C9xix2x3"), 0, 60).time();
				$varCode=mt_rand(2000,9000);


		       $sql="INSERT INTO subscribers (sAccountLimit,sFname,sLname,sEmail,sPhone,sPass,sState,sType,sApiKey,sReferal,sPin,sVerCode,sRegStatus)VALUES(5000,:fname,:lname,:email,:phone,:pass,:s,:a,:k,:ref,:pin,:code,0)";

		       $query = $dbh->prepare($sql);

		       $query->bindParam(':fname',$fname,PDO::PARAM_STR);
		       $query->bindParam(':lname',$lname,PDO::PARAM_STR);
		       $query->bindParam(':email',$email,PDO::PARAM_STR);
		       $query->bindParam(':phone',$phone,PDO::PARAM_STR);
		       $query->bindParam(':pass',$hash,PDO::PARAM_STR);
		       $query->bindParam(':s',$state,PDO::PARAM_STR);
		       $query->bindParam(':a',$account,PDO::PARAM_STR);
		       $query->bindParam(':k',$apiKey,PDO::PARAM_STR);
		       $query->bindParam(':ref',$referal,PDO::PARAM_STR);
		       $query->bindParam(':pin',$transpin,PDO::PARAM_INT);
		       $query->bindParam(':code',$varCode,PDO::PARAM_STR);
		       $query->execute();
		       
		       $lastInsertId = $dbh->lastInsertId();
		       if($lastInsertId){
		       		 
					$data=0; 

					if($saveCookies){
						$_SESSION["loginId"]=$lastInsertId;
						$_SESSION["loginName"]=$fname . " " . $lname;
						$_SESSION["loginEmail"]=$email;
						$_SESSION["loginPhone"]=$phone;
						
						$loginId=base64_encode($lastInsertId);
						$loginState=base64_encode($state);
						$loginPhone=base64_encode($phone);
						$loginAccount=base64_encode("1");
						$loginName=base64_encode($fname);
						
						
						setcookie("loginId", $loginId, time() + (2592000 * 30), "/");
						setcookie("loginState", $loginState, time() + (2592000 * 30), "/");
						setcookie("loginAccount", $loginAccount, time() + (2592000 * 30), "/");
						setcookie("loginPhone", $loginPhone, time() + (31540000 * 30), "/");
						setcookie("loginName", $loginName, time() + (31540000 * 30), "/");


						//Generate User Login Token
						$randomToken = substr(str_shuffle("ABCDEFGHIJklmnopqrstvwxyz"), 0, 10);
						$userLoginToken = time() . $randomToken . mt_rand(100,1000);

						//Set User Login Token
						$_SESSION["loginAccToken"]=$userLoginToken;

						//Save New User Login Token For One Device Login Check

						$sqlAc="INSERT INTO userlogin (user,token) VALUES (:user,:token)";
						$queryAc = $dbh->prepare($sqlAc);
						$queryAc->bindParam(':user',$lastInsertId,PDO::PARAM_STR);
						$queryAc->bindParam(':token',$userLoginToken,PDO::PARAM_STR);
						$queryAc->execute();
					}
					
if($result->sPaymentPointBank == "" || $result->sPaymentPointBank == null){
    
    $this->generatePaymentPointAccount($result->sId, $result->sFname, $result->sLname, $result->sPhone, $result->sEmail);
}
					//Get API Details
					$d=$this->getApiConfiguration();
					$a=$this->getSiteConfiguration();
					$monifyStatus = $this->getConfigValue($d,"monifyStatus");
					$monifyApi = $this->getConfigValue($d,"monifyApi");
					$monifySecrete = $this->getConfigValue($d,"monifySecrete");
					$monifyContract = $this->getConfigValue($d,"monifyContract");
					$adminEmail = $a->email;
				
				$subject = "Welcome (" . $this->sitename . ")";
$message = '
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
        }
        .logo {
            width: 120px;
            height: auto;
        }
        .message {
            margin-top: 20px;
            padding: 20px;
            background-color: #f0f0f0;
            border-radius: 5px;
        }
        .details {
            margin-top: 20px;
            padding: 10px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <a href="https://ibb.co/Tbh9TJM"><img src="https://i.ibb.co/txCVhnp/FB-IMG-1710928970553.jpg" alt="Wapay" border="0" class="logo"></a>
            <h2>Welcome to ' . $this->sitename . '</h2>
        </div>
        <div class="message">
            <p>Hi boss,   &#x1F600;</p>
            <p>Welcome to ' . $this->sitename . '. At ' . $this->sitename . ', you can access instant recharge of Airtime, Data Bundle, CableTv, Electricity Bill Payment, and Airtime to Cash. More features such as buying and selling gift cards, wallet to wallet transfer, and wallet to bank transfer would be made available soon. Our customer support line is available to you 24/7. Stay connected.</p>
            <p><strong>Warning:</strong> Please remember not to share your password or OTP (One Time Password) with anyone. We will never ask for this information.</p>
        </div>
        <div class="details">
            <h3>Our Customer Support Information</h3>
            <p><strong>Whatsapp:</strong> 09047127549</p>
            <p><strong>Facebook:</strong> Wapay</p>
            <p><strong>Telegram:</strong> Wapay CCS</p>
        </div>
        <p>Thank you for choosing ' . $this->sitename . '.</p>
        <p>Best regards,<br>The ' . $this->sitename . ' Team</p>
    </div>
</body>
</html>
';
$check = self::sendMail($email, $subject, $message);



					//Send Email To Admin
					$subject2="New User Registration (".$this->sitename.")";
					$message2="Hi ".$this->sitename.", "."This is to notify you that a new user just registered on your platform. Please find the below details for your usage: ";
					$message2.="<h3>Name: $fname $lname <br/> Phone Number: $phone <br/> Email: $email <br> State: $state</h3>";
					$message2.="<br/><br/><br/> <i>Notification Powered By Algoprime Technology</i>";
					$check=self::sendMail($adminEmail,$subject2,$message2);

					$data =  ["status" => "success", "msg" => "Registartion Successfull"];

		       		
		       } 
		       else{$data =  ["status" => "fail", "msg" => "Unexpected Error, Please Try Again Later"]; }

			   return (object) $data;
			}
		}




    public function recordBotTransaction($userid, $servicename, $servicedesc, $ref, $amountopay, $oldbalance, $newbalance, $status, $tag, $profit)
    {
        $dbh = self::connect();
        $userid = (float) $userid;
        $status = (float) $status;
        $date = date("Y-m-d H:i:s");

        //If transaction was successful, debit user wallet
        if ($status == 1) {
            $newbalance = $oldbalance;
        }
        $sqlD = "UPDATE bot_subscribers SET sBalance=:nb WHERE sPhone=:id";
        $queryD = $dbh->prepare($sqlD);
        $queryD->bindParam(':id', $userid, PDO::PARAM_INT);
        $queryD->bindParam(':nb', $newbalance, PDO::PARAM_STR);
        $queryD->execute();

        $sql = "INSERT INTO transactions SET sId=:user,transref=:ref,servicename=:sn,servicedesc=:sd,amount=:a,status=:s,dataTag=:t,profit=:pft,oldbal=:ob,newbal=:nb,date=:d";
        $query = $dbh->prepare($sql);
        $query->bindParam(':user', $userid, PDO::PARAM_INT);
        $query->bindParam(':ref', $ref, PDO::PARAM_STR);
        $query->bindParam(':sn', $servicename, PDO::PARAM_STR);
        $query->bindParam(':sd', $servicedesc, PDO::PARAM_STR);
        $query->bindParam(':t', $tag, PDO::PARAM_STR);
        $query->bindParam(':pft', $profit, PDO::PARAM_STR);
        $query->bindParam(':a', $amountopay, PDO::PARAM_STR);
        $query->bindParam(':s', $status, PDO::PARAM_INT);
        $query->bindParam(':ob', $oldbalance, PDO::PARAM_STR);
        $query->bindParam(':nb', $newbalance, PDO::PARAM_STR);
        $query->bindParam(':d', $date, PDO::PARAM_STR);
        $query->execute();

        $lastInsertId = $dbh->lastInsertId();
        if ($lastInsertId) {
            return 0;
        } else {
            return 1;
        }
    }
 //Update Transaction Status
        public function updateMyBotTransactionStatus($userid,$ref,$userbalance,$amountopay,$status,$tag,$profit,$serverlog,$servicedesc){
            
            $dbh=$this->connect();
			$userid=(float) $userid;
			$status=(float) $status;
			$amountopay=(float) $amountopay;
			
            if($status == 1){
                $sqlW = "
                START TRANSACTION;
                    SELECT @oldwallet := sWallet FROM bot_subscribers WHERE sId=:id LIMIT 1 FOR UPDATE;
                    SELECT @newwallet := @oldwallet + $amountopay;
                    UPDATE bot_subscribers SET sWallet=@newwallet WHERE sId=:id;
                    UPDATE transactions SET oldbal=:ubal,newbal=:ubal,status=:status,profit=0,dataTag=:dataTag,servicedesc=:servicedesc,api_response_log=:elog WHERE transref=:ref;
                COMMIT;
                ";
                $queryW = $dbh->prepare($sqlW);
                $queryW->bindParam(':id',$userid,PDO::PARAM_INT);
                $queryW->bindParam(':status',$status,PDO::PARAM_INT);
                $queryW->bindParam(':ref',$ref,PDO::PARAM_STR);
                 $queryW->bindParam(':dataTag',$tag,PDO::PARAM_STR);
                  $queryW->bindParam(':servicedesc',$servicedesc,PDO::PARAM_STR);
                $queryW->bindParam(':ubal',$userbalance,PDO::PARAM_STR);
                $queryW->bindParam(':elog',$serverlog,PDO::PARAM_STR);
                $queryW->execute();
            }
            else{
                //Update Transaction Status
                $sqlD = "UPDATE transactions SET status=:status,profit=:profit,dataTag=:dataTag,servicedesc=:servicedesc,api_response_log=:elog WHERE sId=:user AND transref=:ref";
                $queryD = $dbh->prepare($sqlD);
                $queryD->bindParam(':user',$userid,PDO::PARAM_INT);
                $queryD->bindParam(':status',$status,PDO::PARAM_INT);
                $queryD->bindParam(':ref',$ref,PDO::PARAM_STR);
                 $queryD->bindParam(':dataTag',$tag,PDO::PARAM_STR);
                     $queryD->bindParam(':servicedesc',$servicedesc,PDO::PARAM_STR);
                $queryD->bindParam(':profit',$profit,PDO::PARAM_STR);
                $queryD->bindParam(':elog',$serverlog,PDO::PARAM_STR);
                $queryD->execute();
            }
        }
        
    public function getTransactionu()
    {
        $dbh = self::connect();
        $sql = "SELECT * FROM transactions ORDER BY tId DESC";
        $query = $dbh->prepare($sql);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_ASSOC);
        return $results;
    }

public function getTransactions($page, $limit, $searchQuery)
{
    // Connect to the database
    $dbh = self::connect();

    // Calculate the offset for pagination
    $offset = ($page - 1) * $limit;

    // Start the base SQL query
    $sql = "SELECT * FROM transactions";

    // Add search condition if a search query is provided
    if ($searchQuery) {
        $sql .= " WHERE servicedesc LIKE :searchQuery OR transref LIKE :searchQuery";
    }

    // Add ordering and pagination
    $sql .= " ORDER BY tId DESC LIMIT :limit OFFSET :offset";

    // Prepare the SQL query
    $query = $dbh->prepare($sql);

    // Bind the search query parameter if it’s set
    if ($searchQuery) {
        $query->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
    }

    // Bind the limit and offset for pagination
    $query->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $query->bindValue(':offset', (int)$offset, PDO::PARAM_INT);

    // Execute the query and fetch the results
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_ASSOC);

    return $results;
}

    public function getUsers()
    {
        $dbh = self::connect();
        $sql = "SELECT * FROM bot_subscribers";
        $query = $dbh->prepare($sql);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_ASSOC);
        return $results;
    }

    public function getUsersDetail($id)
    {
        $dbh = self::connect();
        $sql = "SELECT * FROM transactions WHERE sId = :id ORDER BY tId DESC";
        $query = $dbh->prepare($sql);
        $query->bindParam(':id', $id, PDO::PARAM_INT);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_ASSOC);
        return $results;
    }

    public function fetchTotalsForToday($date)
    {
        $dbh = self::connect();

        $startDate = $date . " 00:00:00";
        $endDate = $date . " 23:59:59";

        // Total Payvessel Funding for today
        $sqlPayvesselFundingToday = "SELECT SUM(amount) as totalPayvesselFunding FROM transactions WHERE servicename = 'Payvessel Funding' AND DATE(date) = CURDATE()";
        $queryPayvesselFundingToday = $dbh->prepare($sqlPayvesselFundingToday);
        $queryPayvesselFundingToday->execute();
        $totalPayvesselFunding = $queryPayvesselFundingToday->fetch(PDO::FETCH_ASSOC)['totalPayvesselFunding'];

        // Total Monnify Funding
        $sqlMonnifyFunding = "SELECT SUM(amount) as totalMonnifyFunding FROM transactions WHERE servicename = 'Monnify Funding' AND DATE(date) = CURDATE()";
        $queryMonnifyFunding = $dbh->prepare($sqlMonnifyFunding);
        $queryMonnifyFunding->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryMonnifyFunding->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryMonnifyFunding->execute();
        $totalMonnifyFunding = $queryMonnifyFunding->fetch(PDO::FETCH_ASSOC)['totalMonnifyFunding'];

        // Total Successful Transactions
        $sqlSuccessfulTransactions = "SELECT COUNT(*) as totalSuccessfulTransactions FROM transactions WHERE status = 0 AND date BETWEEN :startDate AND :endDate";
        $querySuccessfulTransactions = $dbh->prepare($sqlSuccessfulTransactions);
        $querySuccessfulTransactions->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $querySuccessfulTransactions->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $querySuccessfulTransactions->execute();
        $totalSuccessfulTransactions = $querySuccessfulTransactions->fetch(PDO::FETCH_ASSOC)['totalSuccessfulTransactions'];

        // Total Failed Transactions
        $sqlFailedTransactions = "SELECT COUNT(*) as totalFailedTransactions FROM transactions WHERE status = 1 AND date BETWEEN :startDate AND :endDate";
        $queryFailedTransactions = $dbh->prepare($sqlFailedTransactions);
        $queryFailedTransactions->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryFailedTransactions->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryFailedTransactions->execute();
        $totalFailedTransactions = $queryFailedTransactions->fetch(PDO::FETCH_ASSOC)['totalFailedTransactions'];

        // Total Data Sold
        $sqlDataSold = "SELECT SUM(amount) as totalDataSold FROM transactions WHERE servicename = 'Data' AND status = 0 AND date BETWEEN :startDate AND :endDate";
        $queryDataSold = $dbh->prepare($sqlDataSold);
        $queryDataSold->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryDataSold->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryDataSold->execute();
        $totalDataSold = $queryDataSold->fetch(PDO::FETCH_ASSOC)['totalDataSold'];

        // Total Data GB Sold
        $sqlDataGbSold = "SELECT dataTag FROM transactions WHERE servicename = 'Data' AND status = 0 AND date BETWEEN :startDate AND :endDate";
        $queryDataGbSold = $dbh->prepare($sqlDataGbSold);
        $queryDataGbSold->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryDataGbSold->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryDataGbSold->execute();
        $dataTags = $queryDataGbSold->fetchAll(PDO::FETCH_ASSOC);

        $totalDataGbSoldGB = 0;

        foreach ($dataTags as $dataTag) {
            $dataValue = strtoupper($dataTag['dataTag']);
            if (strpos($dataValue, 'GB') !== false) {
                $totalDataGbSoldGB += floatval($dataValue);
            } elseif (strpos($dataValue, 'MB') !== false) {
                $totalDataGbSoldGB += floatval($dataValue) / 1000;
            }
        }

        $totalDataGbSoldGBFormatted = $totalDataGbSoldGB;

        // Total Airtime
        $sqlAirtime = "SELECT SUM(amount) as totalAirtime FROM transactions WHERE servicename = 'Airtime' AND status = 0 AND date BETWEEN :startDate AND :endDate";
        $queryAirtime = $dbh->prepare($sqlAirtime);
        $queryAirtime->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryAirtime->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryAirtime->execute();
        $totalAirtime = $queryAirtime->fetch(PDO::FETCH_ASSOC)['totalAirtime'];

        // Total Profit
        $sqlProfit = "SELECT SUM(profit) as totalProfit FROM transactions WHERE status = 0 AND date BETWEEN :startDate AND :endDate";
        $queryProfit = $dbh->prepare($sqlProfit);
        $queryProfit->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryProfit->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryProfit->execute();
        $totalProfit = $queryProfit->fetch(PDO::FETCH_ASSOC)['totalProfit'];

        // Total Transactions
        $sqlTotalTransactions = "SELECT COUNT(*) as totalTransactions FROM transactions WHERE date BETWEEN :startDate AND :endDate";
        $queryTotalTransactions = $dbh->prepare($sqlTotalTransactions);
        $queryTotalTransactions->bindParam(':startDate', $startDate, PDO::PARAM_STR);
        $queryTotalTransactions->bindParam(':endDate', $endDate, PDO::PARAM_STR);
        $queryTotalTransactions->execute();
        $totalTransactions = $queryTotalTransactions->fetch(PDO::FETCH_ASSOC)['totalTransactions'];

        // Total User Balance
        $sqlTotalUserBalance = "SELECT SUM(sBalance) as totalUserBalance FROM bot_subscribers";
        $queryTotalUserBalance = $dbh->prepare($sqlTotalUserBalance);
        $queryTotalUserBalance->execute();
        $totalUserBalance = $queryTotalUserBalance->fetch(PDO::FETCH_ASSOC)['totalUserBalance'];

        return [
            'totalPayvesselFunding' => $totalPayvesselFunding,
            'totalMonnifyFunding' => $totalMonnifyFunding,
            'totalSuccessfulTransactions' => $totalSuccessfulTransactions,
            'totalFailedTransactions' => $totalFailedTransactions,
            'totalDataSold' => $totalDataSold,
            'totalDataGbSold' => strval($totalDataGbSoldGBFormatted),
            'totalAirtime' => strval($totalAirtime),
            'totalProfit' => $totalProfit,
            'totalTransactions' => $totalTransactions,
            'totalUserBalance' => strval($totalUserBalance),
        ];
    }
  //Update Transaction Details
    public function updateTransactionStatus($user, $trans, $transstatus, $amount,$old,$new)
    {
        $dbh = $this->connect();

        $transstatus = (int) $transstatus;
        $trans =$trans;
        $user = $user;
        $amount =$amount;

        $theStatus = $transstatus;

        if ($transstatus == 10) {
            $theStatus = 0;
        }
        if ($transstatus == 11) {
            $theStatus = 1;
        }

        $sqlD = "UPDATE transactions SET status=:status WHERE transref=:ref";
        $queryD = $dbh->prepare($sqlD);
        $queryD->bindParam(':status', $theStatus, PDO::PARAM_INT);
        $queryD->bindParam(':ref', $trans, PDO::PARAM_STR);
        $queryD->execute();

        //11 Fail And Refund --- 10 Success And Debit
        if ($transstatus == 11 || $transstatus == 10) {
            $sqlW = "SELECT sWallet FROM subscribers WHERE sId=1";
            $queryW = $dbh->prepare($sqlW);
            $queryW->execute();
            $resultW = $queryW->fetch(PDO::FETCH_OBJ);
            $oldbalance = (float) $resultW->sWallet;

            if ($transstatus == 10) {
                $newbalance = $oldbalance - $amount;
            }
            if ($transstatus == 11) {
                $newbalance = $oldbalance + $amount;
            }

            $sqlS = "UPDATE bot_subscribers SET sBalance=:nb WHERE sId=:id";
            $queryS = $dbh->prepare($sqlS);
            $queryS->bindParam(':id', $user, PDO::PARAM_INT);
            $queryS->bindParam(':nb', $newbalance, PDO::PARAM_STR);
            $queryS->execute();

            //Record Transaction
            if ($transstatus == 10) {
                $servicename = "Debit";
                $servicedesc = "Debit of N{$amount} for tansaction reference {$trans}.";
                $status = 0;
                $date = date("Y-m-d H:i:s");
                $ref = "DEBIT/" . $trans . "/" . time();
            }

            if ($transstatus == 11) {
                $servicename = "Refund";
                $servicedesc = "Refund of N{$amount} for tansaction reference {$trans}.";
                $status = 0;
                $date = date("Y-m-d H:i:s");
                $ref = "REFUND/" . $trans . "/" . time();
            }

            $sql = "INSERT INTO transactions SET sId=:user,transref=:ref,servicename=:sn,servicedesc=:sd,amount=:a,status=:s,oldbal=:ob,newbal=:nb,date=:d";
            $query = $dbh->prepare($sql);
            $query->bindParam(':user', $user, PDO::PARAM_INT);
            $query->bindParam(':ref', $ref, PDO::PARAM_STR);
            $query->bindParam(':sn', $servicename, PDO::PARAM_STR);
            $query->bindParam(':sd', $servicedesc, PDO::PARAM_STR);
            $query->bindParam(':a', $amount, PDO::PARAM_STR);
            $query->bindParam(':s', $status, PDO::PARAM_INT);
            $query->bindParam(':ob', $old, PDO::PARAM_STR);
            $query->bindParam(':nb', $new, PDO::PARAM_STR);
            $query->bindParam(':d', $date, PDO::PARAM_STR);
            $query->execute();

            return 0;
        }
    }
    public function creditDebitUser($email, $action, $amount, $reason, $ref, $old, $new)
    {
        $dbh = $this->connect();
        $sql = "SELECT * FROM bot_subscribers WHERE sPhone = :e";
        $query = $dbh->prepare($sql);
        $query->bindParam(':e', $email, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetch(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            $amount = (float) $amount;
            $oldbalance = (float) $old;
            $userId = $results->sPhone;

            if ($amount > $oldbalance && $action == "Debit") {
                return 2;
            } else {
                if ($action == "Credit") {
                    $newbalance = $oldbalance + $amount;
                } elseif ($action == "Debit") {
                    $newbalance = $oldbalance - $amount;
                } else {
                    return 3;
                }

                $servicename = "Wallet {$action}";
                $servicedesc = "Wallet {$action} of N{$amount} for user {$email}. Reason: {$reason}";
                $message = "Operation Successful. Account {$action}ed with N{$amount}. <br/> Old Balance Is: N" . number_format($oldbalance) . " <br/> New Balance Is: N" . number_format($newbalance) . ".";
                $status = 0;
                $date = date("Y-m-d H:i:s");

                $sql2 = "INSERT INTO transactions SET sId=:user,transref=:ref,servicename=:sn,servicedesc=:sd,amount=:a,status=:s,oldbal=:ob,newbal=:nb,date=:d";
                $query2 = $dbh->prepare($sql2);
                $query2->bindParam(':user', $userId, PDO::PARAM_INT);
                $query2->bindParam(':ref', $ref, PDO::PARAM_STR);
                $query2->bindParam(':sn', $servicename, PDO::PARAM_STR);
                $query2->bindParam(':sd', $servicedesc, PDO::PARAM_STR);
                $query2->bindParam(':a', $amount, PDO::PARAM_STR);
                $query2->bindParam(':s', $status, PDO::PARAM_INT);
                $query2->bindParam(':ob', $oldbalance, PDO::PARAM_STR);
                $query2->bindParam(':nb', $newbalance, PDO::PARAM_STR);
                $query2->bindParam(':d', $date, PDO::PARAM_STR);
                $query2->execute();

                $lastInsertId = $dbh->lastInsertId();
                if ($lastInsertId) {
                    $response = [];
                    $sql3 = "UPDATE bot_subscribers SET sBalance=:bal WHERE sPhone=:id";
                    $query3 = $dbh->prepare($sql3);
                    $query3->bindParam(':id', $email, PDO::PARAM_INT);
                    $query3->bindParam(':bal', $newbalance, PDO::PARAM_STR);
                    if ($query3->execute()) {
                        $response["status"] = "success";
                        $response["msg"] = $message;
                    } else {
                        $response["status"] = "fail";
                        $response["msg"] = "Could Not Update Balance.";
                    }

                    return $response;
                }
            }
        } else {
            return 1;
        }
    }
}

?>
