<?php
require_once "../../autoloader.php";
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$response = [];
$controller = new SubscriberModel();

date_default_timezone_set('Africa/Lagos');
$input = @file_get_contents("php://input");
$body = json_decode($input, true);


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     $results = [];
     foreach ($body as $item) {
          $chat_id = $item['chat_id'];
          $balance = $item['res_amount'];

          $result = $controller->updateUserId($chat_id, $balance);

          if ($result["status"] == "fail") {
               header('HTTP/1.0 400 Invalid Info');
               $response['status'] = "fail";
               $response['msg'] = "The Info is invalid";
               echo json_encode($response);
               exit();
          } else {
               $results[] = $result;
          }
     }
     $response = ['status' => 'success', 'results' => $results];
     echo json_encode($response);
     exit();
} else {
     $response = ['status' => 'error', 'message' => 'Invalid request method'];
     echo json_encode($response);
}
?>
