<?php
require_once "../../autoloader.php";
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");
$headers = apache_request_headers();
$response = [];
$controller = new SubscriberModel();

date_default_timezone_set('Africa/Lagos');
$input = @file_get_contents("php://input");
$body = json_decode($input);


if (isset($_GET["transactions"])) {
     $response["status"] = "success";
     $response["transactions"] = $controller->getTransactions();
     echo json_encode($response);
     exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     $userid = $body->user_id;
     $servicename = $body->service_name;
     $servicedesc = $body->description ? $body->description : "D";
     $ref = $body->ref;
     $profit = $body->profit ? $body->profit : "";
     $tag = $body->dataTag ? $body->dataTag : "";
     $amountopay = $body->amount;
     $oldbalance = strval($body->old) ;
     $newbalance = $oldbalance - $amountopay;
     $status = $body->status ? $body->status : "0";

     $result = $controller->recordBotTransaction($userid, $servicename, $servicedesc, $ref, $amountopay, $oldbalance, $newbalance, $status, $tag, $profit);

     if ($result["status"] == "fail") {
          header('HTTP/1.0 400 Invalid Info');
          $response['status'] = "fail";
          $response['msg'] = "The Info is invalid";
          echo json_encode($response);
          exit();
     } else {
          $response = ['status' => 'success'];
          echo json_encode($response);
          exit();
     }
} else {
     $response = ['status' => 'error', 'message' => 'Invalid request method'];
     echo json_encode($response);
}
?>
