<?php
require_once "../../autoloader.php";
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE");
header(
  "Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin"
);
$headers = apache_request_headers();
$response = [];
$controller = new SubscriberModel();

date_default_timezone_set('Africa/Lagos');
$input = @file_get_contents("php://input");
file_put_contents("data_error_log2.txt",json_encode($input));
$data = json_decode($input);

if (isset($_GET["plans"])) {
  $response["status"] = "success";
  $response["plans"] = $controller->getDataPlans();
  echo json_encode($response);
  exit();
}

if (isset($_GET["network"])) {
  $response["network"] = $controller->getNetwork();
  echo json_encode($response);
  exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $network = $data->network;
  $general = $data->networkStatus;
  $vtuStatus = $data->vtuStatus;
  $sharesellStatus = $data->sharesellStatus;
  $airtimepin = $data->airtimepinStatus;
  $datapin = $data->datapinStatus;
  $sme = $data->smeStatus;
  $sme2 = $data->sme1Status;
  $datashare = $data->datashareStatus;
  $gifting = $data->giftingStatus;
  $corporate = $data->corporateStatus;
  $networkid = $data->networkid;
  $vtuId = $data->vtuId;
  $sharesellId = $data->sharesellId;
  $smeId = $data->smeId;
  $sme2Id = $data->sme2Id;
  $datashareId = $data->datashareId;
  $giftingId = $data->giftingId;
  $corporateId = $data->corporateId;
  $status = $data->status;
  $nId = $data->nId;

  function switchNetwork($network)
  {
    switch ($network) {
      case 'MTN':
        return 1;
      case 'AIRTEL':
        return 4;
      case 'GLO':
        return 2;
      case '9MOBILE':
        return 3;
      default:
        return 0;
    }
  }

  $network = switchNetwork($network);

  $result = $controller->updateNetworkSetting(
    $network,
    $general,
    $vtuStatus,
    $sharesellStatus,
    $airtimepin,
    $datapin,
    $sme,
    $sme2,
    $datashare,
    $gifting,
    $corporate,
    $networkid,
    $vtuId,
    $sharesellId,
    $smeId,
    $sme2Id,
    $datashareId,
    $giftingId,
    $corporateId,
    $status
  );

  if ($result["status"] == "fail") {
    header('HTTP/1.0 400 Invalid Info');
    $response['status'] = "fail";
    $response['msg'] = "The Info is invalid";
    echo json_encode($response);
    exit();
  } else {
    $response = ['status' => 'success'];
    echo json_encode($network);
    exit();
  }
} else {
  header('HTTP/1.0 400 Invalid Info');
  $response = ['status' => 'error', 'message' => 'Invalid request method'];
  echo json_encode($response);
}
?>
